import java.io.*;

public class RandomSensorFile {
	public static final int ID_SIZE = 4;
	public static final int RECORD_SIZE = ID_SIZE * 2 + 4 + 8;
	
	public static void main(String[] args) {
		SensorReading[] list= new SensorReading[4];
		list[0]= new SensorReading("S1  ", 1, 50.0);
		list[1]= new SensorReading("S22 ", 2, 70.0);
		list[2]= new SensorReading("S308", 4, 90.0);
		list[3]= new SensorReading("S4  ", 7, 0.0);
		try {
			FileOutputStream f= new FileOutputStream("sensorRandom.dat");
			DataOutputStream out= new DataOutputStream(f);
			writeData(list, out);
			out.close();
			
			RandomAccessFile in= new RandomAccessFile("sensorRandom.dat", "r");			
			SensorReading[] newList= readData(in);
			in.close();
			
			for (int i=0; i < newList.length; i++)
				System.out.println(newList[i]);
				
		} catch(IOException e) {
			System.out.println(e);
		}
	}
	
	public static void writeData(SensorReading[] s, DataOutputStream out) throws IOException {
		for (int i= 0; i < s.length; i++) {
			String id= s[i].getID();
			int time= s[i].getTime();
			double reading= s[i].getReading();
			out.writeChars(id);
			out.writeInt(time);
			out.writeDouble(reading);
		}
	}
	
	public static SensorReading[] readData(RandomAccessFile in) throws IOException {
		int n= (int) (in.length()/ RECORD_SIZE);
		SensorReading[] s= new SensorReading[n];
		for (int i= n-1; i >= 0; i--) {
			int j= (n-1) - i;	// Reverse order of sensor readings
			s[j]= new SensorReading();
			in.seek(i*RECORD_SIZE);
			readDataFields(in, s[j]);
		}
		return s;
	}
	
	public static void readDataFields(DataInput in, SensorReading s) throws IOException {
		StringBuffer b = new StringBuffer(ID_SIZE);
		for (int i = 0; i < ID_SIZE; i++) {
			char ch = in.readChar();
			b.append(ch);
		}
		s.setID(b.toString());
		s.setTime(in.readInt());
		s.setReading(in.readDouble());
	}
}